#ifndef __SDK_ERROR_H__
#define __SDK_ERROR_H__

///< error code
typedef enum sdks_error_e
{
	SDKS_ERR_OK,
	SDKS_ERROR_UNKNOWN = 1,                        ///< unknown error
	SDKS_ERROR_SERVER_BUSY = 2,                    ///< server busy
	SDKS_ERROR_NOT_SUPPORT = 3,                    ///< not support
	SDKS_ERROR_PARAMETER = 4,                      ///< error parameter
	SDKS_ERROR_REQUEST_TIMEOUT = 5,                ///< request timeout
	SDKS_ERROR_DEV_AUTH_CODE = 3100,               ///< authorization code error, authorization failed
	SDKS_ERROR_DEV_BIND_TO_DEV = 3101,             ///< device is bound to another device
	SDKS_ERROR_DEV_BIND_TO_ACCOUNT = 3102,         ///< device is bound to the account
	SDKS_ERR_NO_FRAME = 10000,                    ///< error no frame
	SDKS_ERR_UNREACHABLE,		                  ///< device unreachable
	SDKS_ERR_CONNECT_TIMEOUT,	                  ///< connect timeout
	SDKS_ERR_DISCONNECT,		                  ///< disconnect
	SDKS_ERR_DECODE,			                  ///< too many decoders
	SDKS_ERR_REC,				                  ///< too many recordings
	SDKS_ERR_CAPTURE,			                  ///< capture error
	SDKS_ERR_VIEW,				                  ///< too many views
	SDKS_ERR_NOT_OPEN_VIEW,	                      ///< not open view
	SDKS_ERR_TOO_MANY_STREAM,	                  ///< too many streams
}sdks_error_e;

#endif
